/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client;

import com.ibm.hsc.client.PIDataBeanInterface;
import com.ibm.hsc.common.util.CSVRecord;
import com.ibm.hsc.websm.frame.CSPStateText;
import java.util.BitSet;
import java.util.Locale;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class PIFrameDataBean
implements PIDataBeanInterface {
    public static final String USER_DEFINED_NAME_KEY = "name";
    public static final String NEW_USER_NAME_KEY = "new_name";
    public static final String NAME_KEY = "frame_name";
    public static final String FRAME_TYPE_MODEL_KEY = "type_model";
    public static final String FRAME_SERIAL_NUM_KEY = "serial_num";
    public static final String FRAME_TYPE_KEY = "frame_type";
    public static final String FRAME_NUMBER_KEY = "frame_num";
    public static final String STATE_KEY = "state";
    public static final String IP_ADDR_SIDE_A_KEY = "ipaddr_a";
    public static final String IP_ADDR_SIDE_B_KEY = "ipaddr_b";
    public static final String PASSWORD_STATUS_KEY = "password_status";
    public static final String KEY_PLATFORM_IPL_SIDE_A = "power_on_side_a";
    public static final String KEY_PLATFORM_IPL_SIDE_B = "power_on_side_b";
    public static final String KEY_PLATFORM_CURR_IPL_SIDE_A = "curr_power_on_side_a";
    public static final String KEY_PLATFORM_NEXT_IPL_SIDE_A = "pend_power_on_side_a";
    public static final String KEY_PLATFORM_CURR_IPL_SIDE_B = "curr_power_on_side_b";
    public static final String KEY_PLATFORM_NEXT_IPL_SIDE_B = "pend_power_on_side_b";
    public static final short IPL_SIDE_PERMANENT = 0;
    public static final short IPL_SIDE_TEMPORARY = 1;
    public static final String STRING_IPL_SIDE_PERMANENT = "perm";
    public static final String STRING_IPL_SIDE_TEMPORARY = "temp";
    public static final String[] ALL_KEYS = new String[]{"name", "frame_type", "frame_num", "state", "password_status", "curr_power_on_side_a", "pend_power_on_side_a", "curr_power_on_side_b", "pend_power_on_side_b"};
    private String m_internalName;
    private String m_userDefinedName;
    private UnsignedInt8 m_frameType;
    private UnsignedInt16 m_frameNumber;
    private UnsignedInt8 m_state;
    private BitSet m_passwordStatus;
    private String m_ipAddrA;
    private String m_ipAddrB;
    private UnsignedInt8 m_platformNextIplSideA;
    private UnsignedInt8 m_platformCurrIplSideA;
    private UnsignedInt8 m_platformNextIplSideB;
    private UnsignedInt8 m_platformCurrIplSideB;

    public String[] getAllKeys() {
        return ALL_KEYS;
    }

    public String getInternalName() {
        return this.m_internalName;
    }

    public String getUserDefinedName() {
        return this.m_userDefinedName;
    }

    public String getFrameStateString() {
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        String string = this.m_state != null ? CSPStateText.getFrameStateValue(this.m_state.intValue()) : "Unknown";
        Locale.setDefault(locale);
        return string;
    }

    public String getFrameTypeString() {
        String string = this.m_frameType != null ? CSPStateText.getFrameTypeValue(this.m_frameType.intValue()) : "Unknown";
        return string;
    }

    public void setPlatformNextIplSideA(UnsignedInt8 unsignedInt8) {
        this.m_platformNextIplSideA = unsignedInt8;
    }

    public UnsignedInt8 getPlatformNextIplSideA() {
        return this.m_platformNextIplSideA;
    }

    public UnsignedInt8 getPlatformCurrIplSideA() {
        return this.m_platformCurrIplSideA;
    }

    public void setPlatformCurrIplSideA(UnsignedInt8 unsignedInt8) {
        this.m_platformCurrIplSideA = unsignedInt8;
    }

    public void setPlatformNextIplSideB(UnsignedInt8 unsignedInt8) {
        this.m_platformNextIplSideB = unsignedInt8;
    }

    public UnsignedInt8 getPlatformNextIplSideB() {
        return this.m_platformNextIplSideB;
    }

    public UnsignedInt8 getPlatformCurrIplSideB() {
        return this.m_platformCurrIplSideB;
    }

    public void setPlatformCurrIplSideB(UnsignedInt8 unsignedInt8) {
        this.m_platformCurrIplSideB = unsignedInt8;
    }

    public void setUserDefinedName(String string) {
        this.m_userDefinedName = string;
    }

    public UnsignedInt8 getFrameType() {
        return this.m_frameType;
    }

    public void setFrameType(UnsignedInt8 unsignedInt8) {
        this.m_frameType = unsignedInt8;
    }

    public UnsignedInt16 getFrameNumber() {
        return this.m_frameNumber;
    }

    public void setFrameNumber(UnsignedInt16 unsignedInt16) {
        this.m_frameNumber = unsignedInt16;
    }

    public UnsignedInt8 getState() {
        return this.m_state;
    }

    public void setState(UnsignedInt8 unsignedInt8) {
        this.m_state = unsignedInt8;
    }

    public String getIpAddrA() {
        return this.m_ipAddrA;
    }

    public void setIpAddrA(String string) {
        this.m_ipAddrA = string;
    }

    public String getIpAddrB() {
        return this.m_ipAddrB;
    }

    public void setIpAddrB(String string) {
        this.m_ipAddrB = string;
    }

    public BitSet getPasswordStatus() {
        return this.m_passwordStatus;
    }

    public void setPasswordStatus(BitSet bitSet) {
        this.m_passwordStatus = bitSet;
    }

    public void setInternalName(String string) {
        this.m_internalName = string;
    }

    public String toString(String[] stringArray, boolean bl, String string) {
        CSVRecord cSVRecord = new CSVRecord(true, string);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string2;
            String string3 = stringArray[i];
            if (USER_DEFINED_NAME_KEY.equals(string3)) {
                CSVRecord.append(cSVRecord, string3, this.m_userDefinedName, bl);
                continue;
            }
            if (FRAME_TYPE_MODEL_KEY.equals(string3)) {
                string2 = null;
                if (this.m_internalName != null && (n = this.m_internalName.indexOf("*")) >= 0) {
                    string2 = this.m_internalName.substring(0, n);
                }
                CSVRecord.append(cSVRecord, string3, string2, bl);
                continue;
            }
            if (FRAME_SERIAL_NUM_KEY.equals(string3)) {
                string2 = null;
                if (this.m_internalName != null && (n = this.m_internalName.indexOf("*")) >= 0) {
                    string2 = this.m_internalName.substring(n + 1);
                }
                CSVRecord.append(cSVRecord, string3, string2, bl);
                continue;
            }
            if (FRAME_TYPE_KEY.equals(string3)) {
                CSVRecord.append(cSVRecord, string3, this.getFrameTypeString(), bl);
                continue;
            }
            if (FRAME_NUMBER_KEY.equals(string3)) {
                CSVRecord.append(cSVRecord, string3, (Number)this.m_frameNumber, bl);
                continue;
            }
            if (STATE_KEY.equals(string3)) {
                CSVRecord.append(cSVRecord, string3, this.getFrameStateString(), bl);
                continue;
            }
            if (IP_ADDR_SIDE_A_KEY.equals(string3)) {
                CSVRecord.append(cSVRecord, string3, this.m_ipAddrA, bl);
                continue;
            }
            if (IP_ADDR_SIDE_B_KEY.equals(string3)) {
                CSVRecord.append(cSVRecord, string3, this.m_ipAddrB, bl);
                continue;
            }
            if (PASSWORD_STATUS_KEY.equals(string3)) {
                if (this.m_passwordStatus == null) continue;
                CSVRecord.append(cSVRecord, string3, this.m_passwordStatus.toString(), bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_IPL_SIDE_A.equals(string3)) {
                string2 = null;
                if (this.m_platformCurrIplSideA != null) {
                    if (0 == this.m_platformCurrIplSideA.intValue()) {
                        string2 = STRING_IPL_SIDE_PERMANENT;
                    } else if (1 == this.m_platformCurrIplSideA.intValue()) {
                        string2 = STRING_IPL_SIDE_TEMPORARY;
                    }
                }
                CSVRecord.append(cSVRecord, string3, string2, bl);
                continue;
            }
            if (KEY_PLATFORM_NEXT_IPL_SIDE_A.equals(string3)) {
                string2 = null;
                if (this.m_platformNextIplSideA != null) {
                    if (0 == this.m_platformNextIplSideA.intValue()) {
                        string2 = STRING_IPL_SIDE_PERMANENT;
                    } else if (1 == this.m_platformNextIplSideA.intValue()) {
                        string2 = STRING_IPL_SIDE_TEMPORARY;
                    }
                }
                CSVRecord.append(cSVRecord, string3, string2, bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_IPL_SIDE_B.equals(string3)) {
                string2 = null;
                if (this.m_platformCurrIplSideB != null) {
                    if (0 == this.m_platformCurrIplSideB.intValue()) {
                        string2 = STRING_IPL_SIDE_PERMANENT;
                    } else if (1 == this.m_platformCurrIplSideB.intValue()) {
                        string2 = STRING_IPL_SIDE_TEMPORARY;
                    }
                }
                CSVRecord.append(cSVRecord, string3, string2, bl);
                continue;
            }
            if (!KEY_PLATFORM_NEXT_IPL_SIDE_B.equals(string3)) continue;
            string2 = null;
            if (this.m_platformNextIplSideB != null) {
                if (0 == this.m_platformNextIplSideB.intValue()) {
                    string2 = STRING_IPL_SIDE_PERMANENT;
                } else if (1 == this.m_platformNextIplSideB.intValue()) {
                    string2 = STRING_IPL_SIDE_TEMPORARY;
                }
            }
            CSVRecord.append(cSVRecord, string3, string2, bl);
        }
        return cSVRecord.toString();
    }

    public String toString() {
        return "[" + this.toString(ALL_KEYS, true, ",") + "]";
    }
}

